
// Copyright (c) 2003 Sonic Foundry, Inc. and Sonic Foundry 
// Media Systems, Inc. Neither this code nor any portion 
// thereof maybe reproduced, altered,or otherwise changed, 
// distributed or copied,without the express written 
// permission of Sonic Foundry. 
// All rights reserved.

// BEGINFILE CurrentSlideArea.js ------------------------------------------------------------------------->

CurrentSlideArea.prototype = new AreaBase();
function CurrentSlideArea(container, containingWindow, ID)
{
	this.m_debugLevel = SfDebug.Verbose;
//	this.m_debugLevel = SfDebug.Information;

	this.InitializeArea(container, containingWindow, ID);

	this.m_imageCache = new ImageCache(this.Container + ".m_imageCache");
	this.CurrentImage;
	this.CurrentThumbNailImage;
		
	this.FullSizeWindowWidth;
	this.FullSizeWindowHeight;
	
	// Options
	this.ShowSlideEffect = false;
	this.ShowNoImage = false;
	this.LoadAltText = false;
	this.AltTextFrame = null;
	this.ShowingTextDescription = false;

	this.OnLoad = function()
	{
		this.Debug("CurrentSlideAreaOnLoad called");
		this.FullSizeWindowWidth = MainHelper.DefaultFullSizeWindowWidth;
		this.FullSizeWindowHeight = MainHelper.DefaultFullSizeWindowHeight;
		this.LoadDefaultImage();
		this.RegisterCurrentSlideEvents();
	}

	this.OnUnLoad = function()
	{
		this.Debug("OnUnLoad called");
		
		MainHelper.EventScript.RemoveHandler(this.ScriptEventHandler);
		MainHelper.EventCommand.RemoveHandler(this.CommandEventHandler);
		MainHelper.EventDataAvailable.RemoveHandler(this.DataAvailableEventHandler);
		MainHelper.EventPlayBegin.RemoveHandler(this.PlayBeginEventHandler);
	}

	this.RegisterCurrentSlideEvents = function()
	{
		this.Debug("RegisterCurrentSlideEvents called");
		
		this.ScriptEventHandler = new SfEventHandler(this.Container);
		this.ScriptEventHandler.Container = this.Container;
		this.ScriptEventHandler.MethodName = "OnScriptEvent";

		MainHelper.EventScript.AddHandler(this.ScriptEventHandler);
		
		this.CommandEventHandler = new SfEventHandler(this.Container);
		this.CommandEventHandler.Container = this.Container;
		this.CommandEventHandler.MethodName = "CurrentSlideOnCommandEvent";
		
		MainHelper.EventCommand.AddHandler(this.CommandEventHandler);
		
		this.DataAvailableEventHandler = new SfEventHandler(this.Container);
		this.DataAvailableEventHandler.Container = this.Container;
		this.DataAvailableEventHandler.MethodName = "CurrentSlideOnDataAvailableEvent";
		
		MainHelper.EventDataAvailable.AddHandler(this.DataAvailableEventHandler);

		this.PlayBeginEventHandler = new SfEventHandler(this.ID);
		this.PlayBeginEventHandler.MethodName = "OnPlayBeginEvent";
		this.PlayBeginEventHandler.Container = this.Container;
		MainHelper.EventPlayBegin.AddHandler(this.PlayBeginEventHandler);
	}

	this.OnPlayBeginEvent = function()
	{
		this.Debug("OnPlayBeginEvent");
		var currentSlideNumber = MainHelper.CurrentSlideNumber;
		this.Debug("CurrentSlideNumber: " + currentSlideNumber);
		if (currentSlideNumber == -1)
		{
			this.Reset();
		}
	}
	
	this.Reset = function()
	{
		this.Debug("Reset called");

		this.LoadDefaultImage();

		this.SetLongDescription('');
		this.SetAltText('Default Slide Image');

		var slideImage = this.GetSlideImage();
		slideImage.onclick = null;
		Util.SetCursor(slideImage, CursorType.Default);

		var magnifyDiv = this.FindMagnifyDiv();
		magnifyDiv.style.visibility  = 'hidden';
		
		this.m_clickInitialized = false;
		return;
	}
	
	this.OnScriptEvent = function(args)
	{
		this.Debug("OnScriptEvent: " + args);
		switch(args.Command)
		{
			case SfScriptCommandType.ShowSlide:
				this.OnShowSlide(args);
				MainHelper.EventSlideChanged.Post(args);
				break;
			case SfScriptCommandType.EndPresentation:
				this.OnEndPresentation(args);
				break;
		}
	}

	this.CurrentSlideOnCommandEvent = function(args)
	{
		this.Debug("CurrentSlideOnCommandEvent: " + args);
		switch(args.Command)
		{
			case SfCommandType.ShowSlideShow:
				this.Show();
				MainHelper.Presentation.WhatIsShowing = WhatIsShowing.SlideShow;
				break;
			case SfCommandType.ShowSlideList:
				this.Hide();
				break;
			case SfCommandType.ShowSlideDescription:
				this.ShowSlideDescriptionClicked();
				break;
			case SfCommandType.Play:
				if (MainHelper.PresentationEnded == true)
				{
					this.GetSlideImage().src = this.DefaultReplayImage;
				}
				if (this.ShowingTextDescription == true)
				{
					this.ShowSlideImage();
				}
				break;
		}
	}
	
	this.ShowSlideDescriptionClicked = function()
	{
		this.Debug("ShowSlideDescriptionClicked()");
		
		if (this.ShowingTextDescription == true)
		{
			this.ShowSlideImage();
		}
		else
		{
			this.ShowSlideDescription();
		}
	}
	
	this.ShowSlideDescription = function()
	{
		this.Debug("ShowSlideDescription()");
		this.GetSlideImage().style.visibility = 'hidden';
		this.FindMagnifyDiv().style.visibility = 'hidden';

		var textDescription = this.FindTextDescriptionElement();
		textDescription.style.visibility = 'visible';

		this.ShowingTextDescription = true;
	}
	
	this.ShowSlideImage = function()
	{
		this.Debug("this.ShowSlideImage()");
		this.GetSlideImage().style.visibility = 'visible';
		this.FindMagnifyDiv().style.visibility = 'visible';

		var textDescription = this.FindTextDescriptionElement();
		textDescription.style.visibility = 'hidden';

		this.ShowingTextDescription = false;
	}
	
	
	this.CurrentSlideOnDataAvailableEvent = function(args)
	{
		this.Debug("CurrentSlideOnDataAvailableEvent");
		this.SetCurrentCaptureImage();
	}

	// the following three vars are emitted
	// this.DefaultReplayImage
	// this.NotStartedImage
	// this.EndedImage
	this.LoadDefaultImage = function()
	{
		this.Debug("LoadDefaultImage called");
		
		var presentationStatus = MainHelper.Presentation.Status;
		var imageSrc;
		switch (presentationStatus)
		{
			case PresentationStatus.CaptureInProgress:
				this.SetCurrentCaptureImage();
				break;
			case PresentationStatus.ReplayReady:
				this.SetSlideImage(this.DefaultReplayImage);
				break;
			case PresentationStatus.Offline:
			case PresentationStatus.CaptureEnded:
				if (MainHelper.Presentation.IsStandAlone == true)
				{
					this.SetSlideImage(this.DefaultReplayImage);
				}
				else
				{	 
					this.SetSlideImage(this.EndedImage);
				}
				break;
			case PresentationStatus.NotReady:
			case PresentationStatus.CaptureReady:
				this.SetSlideImage(this.NotStartedImage);
				break;
			case PresentationStatus.Test:
				this.SetSlideImage(this.NotStartedImage);
				break;
			default:
				SfDebug.DPF(SfDebug.ErrMsgCritical, "CurrentSlideAreaOnLoad: PresentationStatus not known: " + MainHelper.Presentation.Status);
				this.SetSlideImage(this.NotStartedImage);
				break;
		}
	}

	this.SetSlideImage = function(imageSrc)
	{
		var slideImage = this.GetSlideImage();
		slideImage.src = imageSrc;
		slideImage.style.display = "";
	}
	
	this.SetCurrentCaptureImage = function()
	{
		this.Debug("SetCurrentCaptureImage called");
		var slideTimings = MainHelper.Presentation.SlideTimings;
		if (!slideTimings)
		{
			this.SetSlideImage(this.DefaultReplayImage);
			return;
		}
		var max = slideTimings.length;
		this.Debug("Max: " + max);
		if (!max)
		{
			this.SetSlideImage(this.DefaultReplayImage);
			return;
		}
		if (max < 1)
		{
			this.SetSlideImage(this.DefaultReplayImage);
			return;
		}

		// some slides have already been sent at this point		
		var slideTiming = slideTimings[max-1];
		if (slideTiming && slideTiming.Normal && slideTiming.FullSize && slideTiming.ThumbNail)
		{
			this.CurrentImage = MainHelper.Presentation.ImageBaseUrl + "/" + slideTiming.Normal.Image;
			MainHelper.CurrentFullSizeImage = MainHelper.Presentation.ImageBaseUrl + "/" + slideTiming.FullSize.Image;
			this.CurrentThumbNailImage = MainHelper.Presentation.ImageBaseUrl + "/" + slideTiming.ThumbNail.Image;
			MainHelper.CurrentSlideNumber = max;
			this.SetSlideImage(this.CurrentImage);
			this.InitializeClick();
		}
		else
		{
			SfDebug.DPF(SfDebug.ErrMsgCritical, "CurrentSlideArea.SetCurrentCaptureImage, slidetimings are not right");
		}
	}
	
	// makes the slide clickable
	// we don't do it until OnShowSlide has happened
	this.m_clickInitialized = false;
	this.InitializeClick = function()
	{
		this.Debug("CurrentSlide InitializeClick called");
		if (this.m_clickInitialized)
		{
			return;
		}
		
		var imageDiv = this.GetSlideImage();
		imageDiv.onclick = new Function("", "CurrentSlideAreaInstance.OpenFullSizeWindow();");
		imageDiv.title =  this.ShowFullSizeSlideShowText;
		Util.SetCursor(imageDiv, CursorType.Hand);

		var magnifyDiv = this.FindMagnifyDiv();
		Util.SetCursor(magnifyDiv, CursorType.Hand);

		if (this.ShowingTextDescription == true)
		{
			magnifyDiv.style.visibility  = 'hidden';
		}
		else
		{
			magnifyDiv.style.visibility  = 'visible';
		}
		
		magnifyDiv.onclick = new Function("", "CurrentSlideAreaInstance.OpenFullSizeWindow();");
		
		var magnifyImage = this.FindMagnifyImage();
		magnifyImage.title = this.ShowFullSizeSlideShowText;
		magnifyImage.alt = this.ShowFullSizeSlideShowText;

		this.m_clickInitialized = true;
	}
	
	this.OnShowSlide = function(args)
	{
		this.Debug("OnShowSlide called");
		if (args.Index < 1)
		{
			this.Debug("slideNumber < 1");
			MainHelper.CurrentSlideNumber = -1;
			this.Reset();
			return;
		}
		
		this.Debug("OnShowSlide: " +
			", image: " + args.Image);
		
		this.CurrentImage = MainHelper.Presentation.ImageBaseUrl + "/" + args.Image;
		MainHelper.CurrentFullSizeImage = MainHelper.Presentation.ImageBaseUrl + "/" + args.FullSizeImage;
		this.CurrentThumbNailImage = MainHelper.Presentation.ImageBaseUrl + "/" + args.ThumbNailImage;
		var currentSlideNumber = args.Index;
		MainHelper.CurrentSlideNumber = currentSlideNumber;

		var imageElement = this.GetSlideImage();
		if (this.ShowNoImage == false)
		{
			imageElement.src = this.CurrentImage;
		}
		else
		{
			imageElement.src = "";
		}

		this.DoAltTextStuff(imageElement, currentSlideNumber);
		
		if (this.ShowSlideEffect == true)
		{
			this.Slide();
		}
		
		// cache the next image for non-live presentations.
		if ((MainHelper.Presentation.Status!=PresentationStatus.CaptureInProgress) && 
			(currentSlideNumber<MainHelper.Presentation.SlideTimings.length))
		{
			var nextImageName = MainHelper.GetNormalImageName(MainHelper.CurrentSlideNumber + 1);
			var nextImageUrl = MainHelper.Presentation.ImageBaseUrl + "/" + nextImageName;
			this.Debug("Putting " + nextImageUrl + " in cache");
			this.m_imageCache.AddImage(nextImageUrl, true);
		}
		
		this.UpdateFullSizeWindow(this.CurrentImage);
		
		if (!this.m_clickInitialized)
		{
			this.InitializeClick ();
		}
	}
	
	this.DoAltTextStuff = function(imageElement, currentSlideNumber)
	{
		this.Debug("DoAltTextStuff()");
		
		if (this.LoadAltText == false)
		{
			imageElement.alt = "Slide number: " + currentSlideNumber;
			return;
		}
		
		if (MainHelper.Presentation.Status == PresentationStatus.CaptureInProgress)
		{
			imageElement.alt = "Slide number: " + currentSlideNumber;
			//if (this.AltTextFrame == null)
			//{
			//	this.AltTextFrame = new HiddenFrame(this.ID + "AltText");
			//	this.AltTextFrame.CreateFrame();
			//}
			//this.AltTextFrame.Load(this.GetAltTextUrl(currentSlideNumber));
		}
		else
		{
			this.SetAltText(this.AltTexts[currentSlideNumber-1]);
			this.SetLongDescription(this.LongDescriptions[currentSlideNumber-1]);
		}

	}
	
	//public function called when the frame
	//loads
	this.SetAltText = function(text)
	{
		this.Debug("Setting alt text: " + text);
		
		var imageElement = this.GetSlideImage();
		if (!imageElement)
		{
			this.Debug("could not get imageElement");
			return;
		}

		imageElement.alt = text;
	}
	
	//public function called when the frame
	//loads
	this.SetLongDescription = function(text)
	{
		this.Debug("setting long description");
		
		var textDescription = this.FindTextDescriptionElement();

		var textNode = document.createTextNode(text);
		var firstChild = textDescription.childNodes[0];
		if (firstChild)
		{
			textDescription.replaceChild(textNode, firstChild);
		}
		else
		{
			textDescription.appendChild(textNode);
		}
		
	}
	
	this.GetAltTextUrl = function(slideNumber)
	{
		this.Debug("GetAltTextUrl(), slideNumber: " + slideNumber);
		var url =
			"AltText/AltTextLoader.aspx?imageBaseURL=" + MainHelper.Presentation.ImageBaseUrl + 
			"&slideNumber=" + slideNumber;
		return url;
	}

	this.FindMagnifyDiv = function()
	{
		return SfDOM.FindElementFromID(document, this.ID + "magnifyDiv");
	}
	
	this.FindMagnifyImage = function()
	{
		return SfDOM.FindElementFromID(document, this.ID + "magnifyImage");
	}
	
	this.GetSlideImage = function()
	{
		var slideImage = SfDOM.FindElementFromID(document, this.ID + "slideImage");
		return slideImage;
	}

	this.FindTextDescriptionElement = function()
	{
		return SfDOM.FindElementFromID(document, this.ID + "textDescription");
	}
	
	this.Debug = function(str)
	{
		SfDebug.DPF(this.m_debugLevel, "CurrentSlideArea: " + str);
	}
	
	// If FullSizeArea is not open then opens it
	this.OpenFullSizeWindow = function()
	{
		this.Debug("OpenFullSizeWindow called, width: " + this.FullSizeWindowWidth + ", height: " + this.FullSizeWindowHeight);
		if (WindowHelper.IsOpen(MainHelper.PopupWindows.FullSize) == true)
		{
			this.Debug("Is already open");
			return;
		}
		
		MainHelper.PopupWindows.FullSize =
			
			WindowHelper.CreateNamedPopup(
				PopupNames.FullSize,
				"FullSize",
				this.FullSizeWindowWidth,
				this.FullSizeWindowHeight,
				true,
				true);
	}

	this.UpdateFullSizeWindow = function()
	{
		this.Debug("UpdateFullSizeWindow called");
		
		if (WindowHelper.IsOpen(MainHelper.PopupWindows.FullSize) == false)
		{
			this.Debug("window is not open");
			return;
		}
		
		var areaManager = GetAreaManager();
		if (!areaManager)
		{
			this.Debug("could not find AreaManager");
			return;
		}
		var fullSize = areaManager.GetArea(AreaNames.FullSizeSlideArea);
		if (fullSize)
		{
			fullSize.UpdateIfNeeded(MainHelper.CurrentFullSizeImage, MainHelper.CurrentSlideNumber);
		}
	}
	
	this.OnEndPresentation = function(args)
	{
		this.Debug("OnEndPresentation called");
		
		var slideImage = this.GetSlideImage();
		slideImage.src = this.EndedImage;
		slideImage.title = '';
		
		this.SetLongDescription('');
		this.SetAltText('Presentation has ended Image');

		slideImage.onclick = null;
		Util.SetCursor(slideImage, CursorType.Default);

		var magnifyDiv = this.FindMagnifyDiv();
		magnifyDiv.style.visibility  = 'hidden';
		
		this.m_clickInitialized = false;
	}

	this.AnimFinished = true;
	this.CancelAnim = false;
	this.Slide = function()
	{
		if (!this.Position)
		{
			return;
		}
		if (this.AnimFinished == false)
		{
			this.CancelAnim = true;
			return;
		}

		this.CancelAnim = false;
		this.AnimFinished = false;

		this.InitialX = this.Position.X;		
		this.Move(new Point(this.InitialX + this.Width, this.Position.Y));
		
		setTimeout("CurrentSlideAreaInstance.SlideOneStep()", 1);
	}
	
	this.SlideOneStep = function()
	{
		if (this.CancelAnim == true)
		{
			this.Move(new Point(this.InitialX, this.Position.Y));
			this.AnimFinished = true;
			return;
		}
		
		var currentX = this.Position.X;
		if (currentX <= this.InitialX)
		{
			this.Move(new Point(this.InitialX, this.Position.Y));
			this.AnimFinished = true;
			return;
		}
		
		this.Move(new Point(currentX - 100, this.Position.Y));

		setTimeout("CurrentSlideAreaInstance.SlideOneStep()", 1);
	}

}

// ENDFILE CurrentSlideArea.js --------------------------------------------------------------------------->

// BEGINFILE PresentationCardArea.js --------------------------------------------------------------------->

PresentationCardArea.prototype = new AreaBase();
function PresentationCardArea(container, containingWindow, ID)
{
	this.m_debugLevel = SfDebug.Verbose;
//	this.m_debugLevel = SfDebug.Information;

	this.InitializeArea(container, containingWindow, ID);

	this.OnLoad = function()
	{
		this.Debug("PresentationCardAreaOnLoad called");
		this.RegisterPresentationCardEvents();
	}

	this.OnUnLoad = function()
	{
		this.Debug("OnUnLoad called");
		if (MainHelper && MainHelper.EventCommand)
		{
			MainHelper.EventCommand.RemoveHandler(this.CommandEventHandler);
		}
	}

	this.RegisterPresentationCardEvents = function()
	{
		this.CommandEventHandler = new SfEventHandler(this.Container);
		this.CommandEventHandler.Container = "PresentationCardAreaInstance";
		this.CommandEventHandler.MethodName = "PresentationCardOnCommandEvent";
		
		MainHelper.EventCommand.AddHandler(this.CommandEventHandler);
		
	}

	this.PresentationCardOnCommandEvent = function(args)
	{
		this.Debug("PresentationCardOnCommandEvent: " + args);
		switch(args.Command)
		{
			case SfCommandType.ShowInfo:
				this.Show();
				break;
			case SfCommandType.ShowTextSlideList:
				this.Hide();
				break;
		}
	}

	this.Debug = function(str)
	{
		SfDebug.DPF(this.m_debugLevel, "PresentationCard: " + str);
	}
}

// ENDFILE PresentationCardArea.js ----------------------------------------------------------------------->

// BEGINFILE SlideLabelArea.js ------------------------------------------------------------------------->

SlideLabelArea.prototype = new AreaBase();
function SlideLabelArea(container, containingWindow, ID)
{
	this.m_debugLevel = SfDebug.Verbose;
//	this.m_debugLevel = SfDebug.Information;

	this.InitializeArea(container, containingWindow, ID);

	this.OnLoad = function()
	{
		this.RegisterSlideLabelEvents();
	}

	this.OnUnLoad = function()
	{
		this.Debug("OnUnLoad called");
		if (MainHelper && MainHelper.EventCommand)
		{
			MainHelper.EventCommand.RemoveHandler(this.CommandEventHandler);
		}
	}

	this.RegisterSlideLabelEvents = function()
	{
		this.CommandEventHandler = new SfEventHandler(this.Container);
		this.CommandEventHandler.Container = this.Container;
		this.CommandEventHandler.MethodName = "SlideLabelOnCommandEvent";
		
		MainHelper.EventCommand.AddHandler(this.CommandEventHandler);
	}

	this.SlideLabelOnCommandEvent = function(args)
	{
		this.Debug("SlideLabelOnCommandEvent: " + args);
		switch(args.Command)
		{
			case SfCommandType.ShowSlideShow:
				this.Show();
				MainHelper.Presentation.WhatIsShowing = WhatIsShowing.SlideShow;
				break;
			case SfCommandType.ShowSlideList:
				this.Hide();
				break;
		}
	}
	
	this.Debug = function(str)
	{
		SfDebug.DPF(this.m_debugLevel, "SlideLabelArea: " + str);
	}
}

// ENDFILE SlideLabelArea.js --------------------------------------------------------------------------->

// BEGINFILE LiveIndicatorArea.js ------------------------------------------------------------------------->

LiveIndicatorArea.prototype = new AreaBase();
function LiveIndicatorArea(container, containingWindow, ID)
{
	this.m_debugLevel = SfDebug.Verbose;
//	this.m_debugLevel = SfDebug.Information;

	this.activeToolTip = "";
	this.activeSrc = "";
	this.inactiveToolTip = "";
	this.inactiveSrc = "";

	this.InitializeArea(container, containingWindow, ID);
	
	this.GetImage = function()
	{
		this.Debug("GetImage called");
		var image;
		
		image=SfDOM.FindElementFromName(document,this.ID+"Img");
		
		if (image==null)
			image=SfDOM.FindElementFromName(document,this.ID);
			
		if (image==null)
		{
		    SfDebug.DPF(SfDebug.ErrMsgCritical,"No image for "+this.ID+"Img");
		}
			
		return image;
	}

	this.OnLoad = function()
	{
		this.Debug("OnLoad");
		this.AddEventHandlers();
		
		if (MainHelper.Presentation.Status == PresentationStatus.CaptureInProgress || 
			MainHelper.Presentation.Status == PresentationStatus.CaptureReady)
		{
			this.GetImage().title = this.activeToolTip;
			this.GetImage().alt = this.activeToolTip;
			this.GetImage().src = this.activeSrc;
		}
		else
		{
			this.GetImage().title = this.inactiveToolTip;
			this.GetImage().alt = this.inactiveToolTip;
			this.GetImage().src = this.inactiveSrc;
		}
	}

	this.OnUnLoad = function()
	{
		this.Debug("OnUnLoad called");
		this.RemoveEventHandlers();
	}
	
	this.AddEventHandlers = function()
	{
		this.Debug("AddEventHandlers");
		this.ScriptEventHandler = new SfEventHandler("LiveIndicatorArea");
		this.ScriptEventHandler.MethodName = "OnScriptEvent";
		this.ScriptEventHandler.Container = this.Container;
		
		MainHelper.EventScript.AddHandler(this.ScriptEventHandler);
	}

	this.RemoveEventHandlers = function()
	{
		this.Debug("RemoveEventHandler");
		MainHelper.EventScript.RemoveHandler(this.ScriptEventHandler);
	}
	
	this.OnScriptEvent = function(args)
	{
		this.Debug("OnScriptEvent called");
		if (args.Command == SfScriptCommandType.EndPresentation)
		{
			this.GetImage().title = this.inactiveToolTip;
			this.GetImage().alt = this.inactiveToolTip;
			this.GetImage().src = this.inactiveSrc;
		}
	}

	this.Debug = function(str)
	{
		SfDebug.DPF(this.m_debugLevel, "LiveIndicatorArea: " + str);
	}
}

// ENDFILE LiveIndicatorArea.js --------------------------------------------------------------------------->

// BEGINFILE ApplicationVersionArea.js ------------------------------------------------------------------------->

ApplicationVersionArea.prototype = new AreaBase();
function ApplicationVersionArea(container, containingWindow, ID)
{
	this.m_debugLevel = SfDebug.Verbose;
//	this.m_debugLevel = SfDebug.Information;

	this.InitializeArea(container, containingWindow, ID);

	this.OnLoad = function()
	{
		this.Debug("OnLoad");
	}

	this.OnUnLoad = function()
	{
		this.Debug("OnUnLoad");
	}

	this.Debug = function(str)
	{
		SfDebug.DPF(this.m_debugLevel, "ApplicationVersionArea: " + str);
	}
}

// ENDFILE ApplicationVersionArea.js --------------------------------------------------------------------------->

// BEGINFILE SliderArea.js ----------------------------------------------------------------------------->

SliderArea.prototype = new AreaBase();
function SliderArea(container, containingWindow, ID)
{
	this.m_debugLevel = SfDebug.Verbose;
//	this.m_debugLevel = SfDebug.Information;

	this.InitializeArea(container, containingWindow, ID);

	this.IsEnabled = true;
	this.ThumbWidth = -1;
	this.RangeLeft = -1;
	this.RangeRight = -1;
	this.PhysicalLeft = -1;
	this.PhysicalRight = -1;
	
	this.Debug = function(msg)
	{
		SfDebug.DPF(this.m_debugLevel, "Slider: " + msg);
	}
	
	this.OnLoad = function()
	{
		this.Debug("OnLoad");
		this.Initialize();
		this.AddEventHandlers();
	}
	
	this.AddEventHandlers = function()
	{
		this.Debug("AddEventHandlers");
		this.MediaLengthObtainedEventHandler = new SfEventHandler("SliderArea");
		this.MediaLengthObtainedEventHandler.MethodName = "OnMediaLengthObtained";
		this.MediaLengthObtainedEventHandler.Container = this.Container;
		MainHelper.EventPlayerMediaLengthObtained.AddHandler(this.MediaLengthObtainedEventHandler);

		this.PlayerTimerUpdatedEventHandler = new SfEventHandler("SliderArea");
		this.PlayerTimerUpdatedEventHandler.MethodName = "OnPlayerTimerUpdated";
		this.PlayerTimerUpdatedEventHandler.Container = this.Container;
		MainHelper.EventPlayerTimerUpdated.AddHandler(this.PlayerTimerUpdatedEventHandler);
	}
	
	this.RemoveEventHandlers = function()
	{
		this.Debug("RemoveEventHandlers");
		MainHelper.EventPlayerMediaLengthObtained.RemoveHandler(this.MediaLengthObtainedEventHandler);
		MainHelper.EventPlayerTimerUpdated.RemoveHandler(this.PlayerTimerUpdatedEventHandler);
	}
	
	this.OnPlayerTimerUpdated = function(position)
	{
		this.SetPosition(position);
	}
	
	this.OnMediaLengthObtained = function(range)
	{
		this.Debug("OnMediaLengthObtained called: left: " + range.Left + ", right: " + range.Right);
		this.SetRange(range.Left, range.Right);
	}
	
	this.OnUnLoad = function()
	{
		this.Debug("OnUnLoad");
		this.RemoveEventHandlers();
	}
	
	this.Initialize = function()
	{
		this.Debug("Initialize called");
		
		
		this.ElementThumb = SfDOM.FindElementFromID(document, this.ID + "_thumb");
		this.ElementGuide =  SfDOM.FindElementFromID(document, this.ID + "_positionGuide");
		
		this.ThumbWidth = this.ElementThumb.offsetWidth;
		this.PhysicalLeft = this.GetPhysicalLeft();
		this.PhysicalRight = this.PhysicalLeft + this.ElementGuide.offsetWidth;
		this.Debug("PhysicalLeft: " + this.PhysicalLeft);
		this.Debug("PhysicalRight: " + this.PhysicalRight);

		if (MainHelper.Presentation.Status == PresentationStatus.ReplayReady)
		{
			this.ElementThumb.onmousedown = new Function("", this.Container + ".BeginDrag();");
			this.ElementGuide.onclick = new Function("", this.Container + ".GuideOnClick();");
		}
	}
	
	this.GetPhysicalLeft = function()
	{
		var physicalLeft = this.ElementGuide.offsetLeft;
		var par = this.ElementGuide.offsetParent;
		while (par)
		{
			this.Debug("parentOffset: " + par.offsetLeft);
			physicalLeft += par.offsetLeft;
			par = par.offsetParent;
		}
		return physicalLeft;
	}
	
	this.SetRange = function(left,right)
	{
		this.RangeLeft=left;
		this.RangeRight=right;
	}
	
	
	this.LogToPhys = function(LogicalX)
	{
		var PhysX,LogicalWidth,PhysWidth;
		
		LogicalWidth = this.RangeRight-this.RangeLeft;
		PhysWidth = this.PhysicalRight-this.PhysicalLeft;
		
		if (LogicalWidth==0)
		{
			PhysX=0;
		}
		else
		{
			
			PhysX = (PhysWidth) * LogicalX;
			PhysX = PhysX/(LogicalWidth);
		}
		
		PhysX += this.PhysicalLeft;
		
		return PhysX;
	}
	
	this.PhysToLog = function(PhysX)
	{
		var LogX,LogicalWidth,PhysWidth;
		
		LogicalWidth = this.RangeRight-this.RangeLeft;
		PhysWidth = this.PhysicalRight-this.PhysicalLeft;
		
		if (LogicalWidth==0 || PhysWidth==0)
		{
			LogX=0;
		}
		else if (PhysX < this.PhysicalLeft)
		{
			LogX = 0;
		}
		else if (PhysX > this.PhysicalRight)
		{
			LogX = LogicalWidth;
		}
		else
		{
		    PhysX -= this.PhysicalLeft;
			LogX = (LogicalWidth) * PhysX;
			LogX = LogX/(PhysWidth);
		}
		
		return LogX;
	}
	
	this.SetPhysicalPosition = function(x)
	{
	    if (x<this.PhysicalLeft)
	    {
			x=this.PhysicalLeft;
		}
	    if (x>this.PhysicalRight)
	    {
			x=this.PhysicalRight;
		}
		
		this.ElementThumb.style.left = x - this.PhysicalLeft - this.ThumbWidth/2;
	}
	
	this.SetPosition = function(x)
	{
		if (MainHelper.UserIsSliding)
		{
			return;
		}
			
		if (x < this.RangeLeft)
		{
			x = this.RangeLeft;
		}
		if (x > this.RangeRight)
		{
			x = this.RangeRight;
		}
		
		this.SetPhysicalPosition(this.LogToPhys(x));
	}
	
	this.GuideOnClick = function(Event)
	{
		Event = SfBrowserEvent.GetEvent(Event);
		this.Debug("Guide OnClick x " + Event.clientX + " y " + Event.clientY);
		
		var Args=new SliderArgs(SfSliderNotifyType.NewPosition);
			
		Args.Position=this.PhysToLog(Event.clientX);

		this.Debug("Notify Guide Click Position:" + Args.Position);
        MainHelper.EventSliderNotify.Post(Args);
	}
	
	this.BeginDrag = function(Event)
	{
	    if (!this.IsEnabled)
	    {
	        return;
	    }
	
		var SaveThis = this;
		
		MainHelper.UserIsSliding = true;
		
		this.Debug("BeginDrag Called");
		
		Event = SfBrowserEvent.GetEvent(Event);
		
		SfBrowserEvent.Attach("mousemove", OnMove);
		SfBrowserEvent.Attach("mouseup", OnUp);
		SfBrowserEvent.StopPropagation(Event);
		SfBrowserEvent.PreventDefault(Event);
		
		function OnMove(Event)
		{
			SaveThis.Debug("OnMove: Event.clientX " + Event.clientX);
			Event = SfBrowserEvent.GetEvent(Event);

			SfBrowserEvent.StopPropagation(Event);
			SfBrowserEvent.PreventDefault(Event);
			
			if (Event.clientX < SaveThis.PhysicalLeft || Event.clientX > SaveThis.PhysicalRight)
			{
				return;
			}

			SaveThis.SetPhysicalPosition(Event.clientX);
			
			var Args=new SliderArgs(SfSliderNotifyType.DragPosition);
			
			Args.Position=SaveThis.PhysToLog(Event.clientX);

			SaveThis.Debug("Notify Drag Position:" + Args.Position);
			MainHelper.EventSliderNotify.Post(Args);
		}
		
		function OnUp(Event)
		{
			Event = SfBrowserEvent.GetEvent(Event);
			SfBrowserEvent.Detach("mousemove",OnMove);
			SfBrowserEvent.Detach("mouseup",OnUp);
			SfBrowserEvent.StopPropagation(Event);
			SfBrowserEvent.PreventDefault(Event);
			
			var Args = new SliderArgs(SfSliderNotifyType.NewPosition);
			
			Args.Position = SaveThis.PhysToLog(Event.clientX);
			
			SaveThis.Debug("Notify UP Position:"+Args.Position);
			MainHelper.UserIsSliding = false;
	        MainHelper.EventSliderNotify.Post(Args);
		}
		
	}
}

// ENDFILE SliderArea.js ------------------------------------------------------------------------------->

// BEGINFILE SlideSorterArea.js ------------------------------------------------------------------------>

SlideSorterArea.prototype = new AreaBase();
function SlideSorterArea(container, containingWindow, ID)
{
	this.m_debugLevel = SfDebug.Verbose;
//	this.m_debugLevel = SfDebug.Information;

	this.InitializeArea(container, containingWindow, ID);

	// kinda private variables
	this.m_numPerPage = 10;
	this.PageLinkContainerClassName = "";
	this.PageLinkNonCurrentPageClassName = "";
	this.PageLinkCurrentPageClassName = "";
	this.PageLinkPageLabelClassName = "";
	this.CurrentPreviewImage = null;
	this.RestartButton = "";
	this.PreviewSlideTooltip = "";
	this.PlayFromSlideTooltip = "";
	this.ReplayButtonTooltip = "";
	
	this.SlideSorterDiv = "";	
	this.m_slides = new Array();
	this.SlidesInitialized = false;
	
	this.OnLoad = function()
	{
		this.Debug("SlideSorterAreaOnLoad called");
		this.InitializeNumSlidesPerPage();
		this.InitializeSlideTimings();
		this.RegisterSlideSorterAreaEvents();
		this.Debug("SlideSorterArea load finished");
	}

	this.OnUnLoad = function()
	{
		MainHelper.EventSlideChanged.RemoveHandler(this.SlideChangedEventHandler);
		MainHelper.EventCommand.RemoveHandler(this.CommandEventHandler);
		MainHelper.EventPlayBegin.RemoveHandler(this.PlayBeginEventHandler);
	}

	this.RegisterSlideSorterAreaEvents = function()
	{
		this.CommandEventHandler = new SfEventHandler(this.Container);
		this.CommandEventHandler.Container = "SlideSorterAreaInstance";
		this.CommandEventHandler.MethodName = "OnCommandEvent";
		MainHelper.EventCommand.AddHandler(this.CommandEventHandler);	

		this.SlideChangedEventHandler = new SfEventHandler(this.Container);
		this.SlideChangedEventHandler.Container = "SlideSorterAreaInstance";
		this.SlideChangedEventHandler.MethodName = "OnSlideChangedEvent";
		MainHelper.EventSlideChanged.AddHandler(this.SlideChangedEventHandler);	

		this.PlayBeginEventHandler = new SfEventHandler(this.ID);
		this.PlayBeginEventHandler.MethodName = "OnPlayBeginEvent";
		this.PlayBeginEventHandler.Container = this.Container;
		MainHelper.EventPlayBegin.AddHandler(this.PlayBeginEventHandler);
	}

	this.OnPlayBeginEvent = function()
	{
		this.Debug("OnPlayBeginEvent");
		if (this.LastHilitedSlideNumber != -1)
		{
			this.UnHiliteSlide(this.LastHilitedSlideNumber);
		}
	}

	this.OnSlideChangedEvent = function(args)
	{
		this.Debug("OnSlideChangedEvent called: " + args.Index);
		var index = args.Index;
		if (index < 1)
		{
			this.Debug("Resetting");
			if (this.LastHilitedSlideNumber != -1)
			{
				this.UnHiliteSlide(this.LastHilitedSlideNumber);
				this.LastHilitedSlideNumber = -1;
			}
			return;
		}

		if (MainHelper.Presentation.WhatIsShowing != WhatIsShowing.SlideList)
		{
			return;
		}

		var pageNumber = this.CalculateSlidePage(index);
		
		if (this.CurrentPage != pageNumber)
		{
			// the user is probably just skipping around
			if (this.LastHilitedSlideNumber != -1)
			{
				this.UnHiliteSlide(this.LastHilitedSlideNumber);
			}
			return;
		}
		
		if (MainHelper.DynamicAdd == true)
		{
			// always draw page
			this.DrawPage(pageNumber);
		}
		this.HiliteSlide(index);
	}
	
	this.OnCommandEvent = function(args)
	{
		this.Debug("OnCommandEvent: " + args);
		switch(args.Command)
		{
			case SfCommandType.ShowSlideShow:
				this.Hide();
				break;
			case SfCommandType.ShowSlideList:
				var currentPage = this.CalculateCurrentSlidePage();
				if (currentPage != -1)
				{
					this.Debug("Drawing page: " + currentPage);
					this.DrawPage(currentPage);
				}
				else if (MainHelper.MaxSlideTimings > 0)
				{
					this.Debug("Drawing page: " + 1);
					SlideSorterAreaInstance.DrawPage(1);
				}
				this.Show();
				MainHelper.Presentation.WhatIsShowing = WhatIsShowing.SlideList;
				break;
		}
	}
	
	this.InitializeSlides = function()
	{
		this.Debug("InitializeSlides called");
		this.ReplaceWaitForVideoElement();
		this.DrawBlankPage();		
		this.SlidesInitialized = true;
	}

	this.InitializeNumSlidesPerPage = function()
	{
		this.Debug("Initialize NumSlidesPerPage called");
		var cookie = new SfCookie("NumSlidesPerPage");
		var value = cookie.Get();
		this.Debug("cookie Value: " + value);
		if (value)
		{
			this.m_numPerPage = Number(value);
		}
	}

	this.ReplaceWaitForVideoElement = function()
	{
		this.Debug("ReplaceWaitForVideoElement called");
		var element = this.GetDiv();
		var waitForVideoElement = SfDOM.FindElementFromID(document, "waitForVideoNode");
		if (!waitForVideoElement)
		{
			SfDebug.DPF(SfDebug.ErrMsgCritical, "SlideSorterArea: could not find waitForVideoElement");
			return;
		}
		
		// "slideSorterDiv" is the id of what resides under the div with 
		// ID = "SlideSorterArea"
		// <div id="SlideSorterArea">
		//	<div id="slideSorterDiv">
		//	</div>
		// </div>
		var slideSorterDiv = document.createElement("div");
		slideSorterDiv.setAttribute("id", "slideSorterDiv");
		
		element.replaceChild(slideSorterDiv, waitForVideoElement);

	}
	
	this.InitializeSlideTimings = function()
	{
		this.Debug("Initializing slidetimings");
		for (i=0; i<MainHelper.MaxSlideTimings; ++i)
		{
			this.m_slides[i] = new SingleSlide(this, this.Container + ".m_slides[" + i + "]", i+1);
		}
		this.Debug("MaxSlideTimings: " + MainHelper.MaxSlideTimings);
	}
	
	this.CalculateSlidePage = function(slideNumber)
	{
		this.Debug("CalculateSlidePage: " + slideNumber);
		if (slideNumber < 0 || slideNumber > 10000)
		{
			this.Debug("slideNumber < 0 || slideNumber > 10000. returning 1 as slidePage");
			return 1;
		}
		
		var pageNumber = 1;
		while (pageNumber < 1000) // to make sure that there is no infinite loop
		{
			var pageStartSlideNumber = pageNumber * this.m_numPerPage - this.m_numPerPage + 1;
			var pageEndSlideNumber = pageNumber * this.m_numPerPage;
			if (slideNumber >= pageStartSlideNumber && slideNumber <= pageEndSlideNumber)
			{
				return pageNumber;
			}
			++pageNumber;
		}
		alert('Unexpected result. Page number > 999');
	}

	// returns the pagenumber where the current playing slide belongs
	this.CalculateCurrentSlidePage = function()
	{
		this.Debug("CalculateCurrentSlidePage called");
		var currentSlideNumber = MainHelper.CurrentSlideNumber;
		this.Debug("CurrentSlideNumber: " + currentSlideNumber);
		if (currentSlideNumber == -1)
		{
			return -1;
		}
		return this.CalculateSlidePage(currentSlideNumber);
	}
	
	this.DrawBlankPage = function()
	{
		this.Debug("DrawBlankPage called");
		this.SlideSorterDiv = document.createElement("div");
		this.SlideSorterDiv.setAttribute("id", "slideSorterDiv");
		SfDOM.SetCssText(this.SlideSorterDiv, "overflow: auto; width: " + this.Width + "; height: " + this.Height + ";");

		var buttonContainer = document.createElement("span");
		this.ReplayButton = new ReplayButton(this, this.Container + ".ReplayButton");
		buttonContainer.appendChild(this.ReplayButton.CreateButtonArea());
		SfDOM.SetCssText(buttonContainer, "float: left;");
		this.ReplayButton.ImageElement.setAttribute("src", this.ImageBase + "/btn_ReplayNormal.gif");
	
		var pagerContainer = document.createElement("span");
		this.PageLinkManager = new PageLinkManager(this);
		pagerContainer.appendChild(this.PageLinkManager.CreateTopPageLinks());

		this.SlideSorterDiv.appendChild(buttonContainer);
		this.SlideSorterDiv.appendChild(pagerContainer);

		var slidesContainer = document.createElement("div");
		this.SlideSorterDiv.appendChild(slidesContainer);

		for (i=0; i<this.m_numPerPage; ++i)
		{
			// add the element
			// have to create everytime because of freakin mac
			this.m_slides[i] = new SingleSlide(this, this.Container + ".m_slides[" + i + "]", i+1);
			slidesContainer.appendChild(this.m_slides[i].CreateBlankElement());
		}
		
		this.SlideSorterDiv.appendChild(this.PageLinkManager.CreateBottomPageLinks());

		var oldElement = SfDOM.FindElementFromID(document, "slideSorterDiv");
		this.GetDiv().replaceChild(this.SlideSorterDiv, oldElement);

		// needs to be sequentially loaded because of IE BUg
		for (i=0; i<this.m_numPerPage; ++i)
		{
			this.m_slides[i].PreviewLinkInstance.ImageElement.setAttribute("src", this.ImageBase + "/preview_slide_n.gif");
			this.m_slides[i].PlayLinkInstance.ImageElement.setAttribute("src", this.ImageBase + "/play_from_slide_n.gif");
			this.m_slides[i].DividerImageElement.setAttribute("src", this.ImageBase + "/slide_list_divider.gif");
		}
		
		this.Debug("finished drawing blank page");
	}
	
	this.DrawPage = function(pageNumber)
	{
		this.Debug("Drawpage called: " + pageNumber);
		if (this.SlidesInitialized == false)
		{
			this.InitializeSlides();
		}		


		this.PageLinkManager.UpdatePageLinks(pageNumber);

		if (this.LastHilitedSlideNumber != -1)
		{
			this.UnHiliteSlide(this.LastHilitedSlideNumber);
		}

		var pageStartIndex = pageNumber * this.m_numPerPage - this.m_numPerPage;
		var pageEndIndex = pageNumber * this.m_numPerPage;
		// i = slidenumber, counter = position in page
		var counter = 0;
		var currentSlideNumber = MainHelper.CurrentSlideNumber;
		for (i=pageStartIndex; i<pageEndIndex && i< MainHelper.MaxSlideTimings; ++i)
		{
			this.m_slides[counter].ImageElement.setAttribute("src", MainHelper.Presentation.ImageBaseUrl + "/" + MainHelper.Presentation.SlideTimings[i].ThumbNail.Image);
			this.m_slides[counter].PreviewLinkInstance.ImageElement.onclick = new Function("", this.Container + ".ShowBigSlide(" + (i+1) + ");");			
			this.m_slides[counter].PlayLinkInstance.ImageElement.onclick = new Function("", this.Container + ".NavigateToSlide(" + (i+1) + ");");			
			this.m_slides[counter].Element.style.visibility = 'visible';

			if (i+1 == currentSlideNumber)
			{
				this.HiliteSlide(i+1);
			}
			++counter;
		}
		for (i=counter; i<this.m_numPerPage; ++i)
		{
			this.m_slides[i].Element.style.visibility = 'hidden';
		}
		
		this.CurrentPage = pageNumber;
		this.SlideSorterDiv.scrollTop = 0;

		this.Debug("finished drawing page: " + pageNumber);
	}

	this.LastHilitedSlideNumber = -1;
	this.HiliteSlide = function(slideNumber)
	{
		this.Debug("HiliteSlide: " + slideNumber);
		
		var imageElement = this.GetSlideObject(slideNumber).ImageElement;
		if (!imageElement)
		{
			SfDebug.DPF(SfDebug.ErrMsgCritical, 'could not find imageElement');
			return;
		}
		var width = MainHelper.DefaultThumbNailWidth - 8;
		var height = MainHelper.DefaultThumbNailHeight - 8;
		
		SfDOM.SetCssText(imageElement, 'border-style:solid; border-width:4px; border-color:OrangeRed; width:' + width + 'px; height:' + height + 'px;');
			
		if (this.LastHilitedSlideNumber != -1 && this.LastHilitedSlideNumber != slideNumber)
		{
			this.UnHiliteSlide(this.LastHilitedSlideNumber);
		}
		this.LastHilitedSlideNumber = slideNumber;
	}
	
	this.UnHiliteSlide = function(slideNumber)
	{
		var imageElement = this.GetSlideObject(slideNumber).ImageElement;
		if (!imageElement)
		{
			SfDebug.DPF(SfDebug.ErrMsgCritical, 'could not find imageElement');
			return;
		}
		var width = MainHelper.DefaultThumbNailWidth + 2;
		var height = MainHelper.DefaultThumbNailHeight;
		
		SfDOM.SetCssText(imageElement, ';border:none; width:' + width + 'px; height:' + height + 'px;');	
	}
	
	this.GetSlideObject = function(slideNumber)
	{
		var position = (slideNumber - 1) % this.m_numPerPage;
		return this.m_slides[position];
	}
	
	this.Debug = function(str)
	{
		SfDebug.DPF(this.m_debugLevel, "SlideSorterArea: " + str);
	}

	this.ShowBigSlide = function(slideNumber)
	{
		var captureImageInfo;
		var slideTiming;
		
		slideTiming = MainHelper.Presentation.SlideTimings[slideNumber-1];

		if (slideTiming.FullSize.Image)
		{
			captureImageInfo = slideTiming.FullSize;
		}
		else if (slideTiming.Normal.Image)
		{
			captureImageInfo = slideTiming.Normal;
		}
		else
		{
			SfDebug.DPF(SfDebug.ErrMsgCritical, "no image found for slidenumber: " + slideNumber);
		}
					
		this.CurrentPreviewImage = MainHelper.Presentation.ImageBaseUrl + '/' + captureImageInfo.Image;
		
		var areaManager = GetAreaManager();
		if (!areaManager)
		{
			this.Debug("could not find AreaManager");
			return;
		}	
			
		if (WindowHelper.IsOpen(MainHelper.PopupWindows.PreviewSlide) == true)
		{
			var previewSlide = areaManager.GetArea(AreaNames.PreviewSlideArea);
			if (previewSlide)
			{
				previewSlide.ChangeImage(this.CurrentPreviewImage);
			}
		}
		else
		{
			var width = MainHelper.DefaultFullSizeWidth + 2;
			var height = MainHelper.DefaultFullSizeHeight + 2;

			MainHelper.PopupWindows.PreviewSlide =

				WindowHelper.CreateNamedPopup(PopupNames.PreviewSlide, "PreviewSlide", width, height, true, true);
		}
	}

	// remember number is 1 indexed and not 0
	this.NavigateToSlide = function(slideNumber)
	{
		this.Debug("NavigateToSlide(slideNumber: " + slideNumber + ") called");
		var args = new CommandArgs(SfCommandType.NavigateToSlide);
		args.SlideNumber = slideNumber;
		MainHelper.EventCommand.Post(args);
	}
	
	// A single slide represents one thumbnail
	// It contains a "PreviewLink" and a "PlayLink"
	// ParentArea is the slidesorter area instance
	function SingleSlide(parentArea, container, position)
	{
		this.ParentArea = parentArea;
		this.Container = container;
		this.Position = position;
		this.PreviewLinkInstance = new PreviewLink(this.ParentArea, this.Container + ".PreviewLinkInstance", this.Position);
		this.PlayLinkInstance = new PlayLink(this.ParentArea, this.Container + ".PlayLinkInstance", this.Position);
		this.Hilite = false;

		this.CreateBlankElement = function()
		{
			var height = MainHelper.DefaultThumbNailHeight;;
			var width = MainHelper.DefaultThumbNailWidth + 2;// !!! perhaps change this
			
			var cssText = 'float:left;width:' + width;
			
			var singleSlideElement = document.createElement("span");
			singleSlideElement.setAttribute("id", this.ID); 

			var imgContainer = document.createElement("div");
			singleSlideElement.appendChild(imgContainer);
			var imgElement = document.createElement("img");
			imgContainer.appendChild(imgElement);
			imgElement.setAttribute("height", height);
			imgElement.setAttribute("width", width);
			imgElement.style.left = 0;
			this.ImageElement = imgElement;

			var previewLinkElement = this.PreviewLinkInstance.CreateBlankElement();

			Util.SetCursor(previewLinkElement, CursorType.Hand);
			
			singleSlideElement.appendChild(previewLinkElement);
			
			imgElement = this.CreateBlankDividerElement();
			singleSlideElement.appendChild(imgElement);

			var playLinkElement = this.PlayLinkInstance.CreateBlankElement();
			
			Util.SetCursor(playLinkElement, CursorType.Hand);
			
			singleSlideElement.appendChild(playLinkElement);

			SfDOM.SetCssText(singleSlideElement, cssText);
			singleSlideElement.style.visibility = 'hidden';

			this.Element = singleSlideElement;			
			return singleSlideElement;
		}
		
		this.CreateBlankDividerElement = function()
		{
			var imgElement = document.createElement("img");
			imgElement.setAttribute("width", "2");
			SfDOM.SetToolTip(imgElement, "");
			imgElement.setAttribute("border", "0");
			this.DividerImageElement = imgElement;
			return imgElement;
		}
		
		function PreviewLink(parentArea, container, position)
		{
			this.ParentArea = parentArea;
			this.Container = container;
			this.Position = position; 
			this.MouseDownImage = "preview_slide_d.gif";
			this.MouseOverImage = "preview_slide_o.gif";
			this.MouseOutImage = "preview_slide_n.gif"
			this.ImageName = "previewImage_" + this.Position;

			this.CreateBlankElement = function()
			{
				var imgElement = document.createElement("img");
				SfDOM.SetToolTip(imgElement, this.ParentArea.PreviewSlideTooltip);
				imgElement.setAttribute("border", "0");
				imgElement.setAttribute("id", this.ImageName);

				this.AddEvents(imgElement);
				this.ImageElement = imgElement;
				return imgElement;
			}
			
			this.AddEvents = function(link)
			{
				link.onmouseover = new Function("", this.Container + ".OnMouseOver();");
				link.onmouseout = new Function("", this.Container + ".OnMouseOut();");
				link.onmousedown = new Function("", this.Container + ".OnMouseDown();");
			}
			
			this.OnMouseOver = function()
			{
				var image = SfDOM.FindElementFromID(document, this.ImageName);
				image.src = this.ParentArea.ImageBase + "/" + this.MouseOverImage;
			}

			this.OnMouseOut = function()
			{
				var image = SfDOM.FindElementFromID(document, this.ImageName);
				image.src = this.ParentArea.ImageBase + "/" + this.MouseOutImage;
			}

			this.OnMouseDown = function()
			{
				var image = SfDOM.FindElementFromID(document, this.ImageName);
				image.src = this.ParentArea.ImageBase + "/" + this.MouseOutImage;
			}
		}
		
		function PlayLink(parentArea, container, position)
		{
			this.ParentArea = parentArea;
			this.Container = container;
			this.Position = position;
			this.MouseDownImage = "play_from_slide_d.gif";
			this.MouseOverImage = "play_from_slide_o.gif";
			this.MouseOutImage = "play_from_slide_n.gif"
			this.ImageName = "playImage_" + this.Position;

			this.CreateBlankElement = function()
			{
				var imgElement = document.createElement("img");
				SfDOM.SetToolTip(imgElement, this.ParentArea.PlayFromSlideTooltip);
				imgElement.setAttribute("id", this.ImageName);
				
				if (MainHelper.Presentation.Status == PresentationStatus.ReplayReady)
				{
					this.AddEvents(imgElement);
				}
				this.ImageElement = imgElement;
				return imgElement;
			}

			this.AddEvents = function(link)
			{
				link.onmouseover = new Function("", this.Container + ".OnMouseOver();");
				link.onmouseout = new Function("", this.Container + ".OnMouseOut();");
				link.onmousedown = new Function("", this.Container + ".OnMouseDown();");
			}
			
			this.OnMouseOver = function()
			{
				var image = SfDOM.FindElementFromID(document, this.ImageName);
				image.src = this.ParentArea.ImageBase + "/" + this.MouseOverImage;
			}

			this.OnMouseOut = function()
			{
				var image = SfDOM.FindElementFromID(document, this.ImageName);
				image.src = this.ParentArea.ImageBase + "/" + this.MouseOutImage;
			}

			this.OnMouseDown = function()
			{
				var image = SfDOM.FindElementFromID(document, this.ImageName);
				image.src = this.ParentArea.ImageBase + "/" + this.MouseOutImage;
			}
		}
	}

	function ReplayButton(parentArea, container)
	{
		this.ParentArea = parentArea;
		this.Container = container;
		this.ImageName = "replayImg";
		this.ImageElement = null;

		this.CreateButtonArea = function()
		{			
			imgElement = document.createElement("img");
			SfDOM.SetToolTip(imgElement, this.ParentArea.ReplayButtonTooltip);
			imgElement.setAttribute("border", "0");
			imgElement.setAttribute("id", this.ImageName);
			
			Util.SetCursor(imgElement, CursorType.Hand);

			if ( MainHelper.Presentation.Status == PresentationStatus.ReplayReady ) 
			{

				imgElement.setAttribute("src", this.ParentArea.ImageBase + "/btn_ReplayNormal.gif");
				this.AddEvents(imgElement);
			}
			else 
			{
				imgElement.style.display = "none";
			}

			this.ImageElement = imgElement;
			return imgElement;
		}
		
		this.AddEvents = function(link)
		{
			link.onmouseover = new Function("", this.Container + ".OnMouseOver();");
			link.onmouseout = new Function("", this.Container + ".OnMouseOut();");
		    link.onclick = new Function("", this.Container + ".OnClick()");
		}
		
		this.OnMouseOver = function()
		{
			this.ImageElement.src = this.ParentArea.ImageBase + "/btn_ReplayOver.gif";
		}

		this.OnMouseOut = function()
		{
			this.ImageElement.src = this.ParentArea.ImageBase + "/btn_ReplayNormal.gif";
		}

		this.OnClick = function()
		{
			var args = new CommandArgs(SfCommandType.NavigateToSlide);
			args.SlideNumber = "0";
			MainHelper.EventCommand.Post(args);
			this.ImageElement.src = this.ParentArea.ImageBase + "/btn_ReplayNormal.gif";

			MainHelper.CurrentSlideNumber = -1;
			MainHelper.EventPlayBegin.Post(new Object());
		}
	}
	
	function PageLinkManager(parentArea)
	{
		this.ParentArea = parentArea;
		this.SelectedPage = -1;
		this.DebugLevel = SfDebug.Verbose;
		
		this.Debug = function(msg)
		{
			SfDebug.DPF(this.DebugLevel, "PageLinkManager: " + msg);
		}
						
		this.CreateTopPageLinks = function()
		{
			this.TopPageLinkChain = new PageLinkChain(this.ParentArea);
			var pageLinkElement = this.TopPageLinkChain.CreateElement();
			pageLinkElement.setAttribute("id", "pageLinkTop");
			SfDOM.SetCssText(pageLinkElement, 'text-align:right; width: 100%;');
			
			return pageLinkElement;
		}
		
		this.CreateBottomPageLinks = function()
		{
			this.BottomPageLinkChain = new PageLinkChain(this.ParentArea);
			var pageLinkElement = this.BottomPageLinkChain.CreateElement();
			pageLinkElement.setAttribute("id", "pageLinkBottom");
			SfDOM.SetCssText(pageLinkElement, "text-align:right; float: left; width: 100%;");
			
			return pageLinkElement;
		}

		this.UpdatePageLinks = function(pageNumber)
		{
			this.SelectPage(pageNumber);
		}
		
		this.SelectPage = function(pageNumber)
		{
			this.TopPageLinkChain.SelectPage(pageNumber);
			this.BottomPageLinkChain.SelectPage(pageNumber);
			this.SelectedPage = pageNumber;
		}

		function PageLinkChain(parentArea)
		{
			this.ParentArea = parentArea;
			this.NumLinks = 11;
						
			this.CreateElement = function()
			{
				var pageLinkElement = document.createElement("div");
				pageLinkElement.className = SlideSorterAreaInstance.PageLinkContainerClassName;
				var spanElement = document.createElement("span");
				pageLinkElement.appendChild(spanElement);
				spanElement.className = SlideSorterAreaInstance.PageLinkPageLabelClassName;
				var textNode = document.createTextNode(this.ParentArea.PagerPageText +  ": ");
				spanElement.appendChild(textNode);
				
				this.PageLinks = new Array(this.NumLinks + 2);
				var onePageLink = new OnePageLink();
				spanElement.appendChild(onePageLink.CreateElement());
				this.PageLinks[0] = onePageLink;
				for (i=1; i<=this.NumLinks; ++i)
				{
					onePageLink = new OnePageLink();
					spanElement.appendChild(onePageLink.CreateElement());
					this.PageLinks[i] = onePageLink;
				}
				onePageLink = new OnePageLink();
				spanElement.appendChild(onePageLink.CreateElement());
				this.PageLinks[this.NumLinks+1] = onePageLink;
				
				this.Element = pageLinkElement;
				return pageLinkElement;
			}
			
			function PageIndexCalculator(pageNumber, totalPages, toEachSide)
			{
				this.PageNumber = pageNumber;
				this.TotalPages = totalPages;
				this.ToEachSide = toEachSide;
				
				this.GetLeftOverFromEnd = function()
				{
					if ((this.TotalPages - this.PageNumber)  >= this.ToEachSide)
					{
						return 0;
					}
					else
					{
						return this.ToEachSide - (this.TotalPages - this.PageNumber);
					}
				}
				
				this.GetLeftOverFromStart = function()
				{
					if (this.PageNumber > this.ToEachSide)
					{
						return 0;
					}
					else
					{
						return this.ToEachSide - this.PageNumber + 1;
					} 
				}
				
				this.GetStartIndex = function()
				{
					return Math.max(1,  this.PageNumber - this.ToEachSide - this.GetLeftOverFromEnd());	
				}
				
				this.GetEndIndex = function()
				{
					return Math.min(this.TotalPages, this.PageNumber + this.ToEachSide + this.GetLeftOverFromStart());
				}
			}
			
			this.SelectPage = function(pageNumber)
			{
				var totalPages = this.GetTotalPages();
				var toEachSide = (this.NumLinks - 1) / 2;
				var pageIndexCalculator = new PageIndexCalculator(pageNumber, totalPages, toEachSide);
				var startIndex = pageIndexCalculator.GetStartIndex();
				var endIndex = pageIndexCalculator.GetEndIndex();

				var counter = 0;
				if (pageNumber > 1)
				{
					this.PageLinks[counter].SetTextAndPageNumber("<" + this.ParentArea.PagerPreviousText, pageNumber-1);
					this.PageLinks[counter].Show();
					this.PageLinks[counter].MakeLinkClickable();
					++counter;
				}
				for (i=startIndex; i<=endIndex; ++i)
				{
					this.PageLinks[counter].SetTextAndPageNumber(i, i);
					this.PageLinks[counter].Show();
					if (i == pageNumber)
					{
						this.PageLinks[counter].MakeLinkUnClickable();
					}
					else
					{
						this.PageLinks[counter].MakeLinkClickable();
					}
					++counter;
				}				
				if (pageNumber < totalPages)
				{
					this.PageLinks[counter].SetTextAndPageNumber(this.ParentArea.PagerNextText + ">", pageNumber+1);
					this.PageLinks[counter].Show();
					this.PageLinks[counter].MakeLinkClickable();
					++counter;
				}
				
				for (i=counter; i<this.PageLinks.length; ++i)
				{
					this.PageLinks[i].Hide();
				}
			}

			this.GetTotalPages = function()
			{			
				if (MainHelper.MaxSlideTimings <= 0)
				{
					return 0;
				}
				return Math.ceil(MainHelper.MaxSlideTimings / this.ParentArea.m_numPerPage);
			}
			
		}
		
		function OnePageLink()
		{
			this.CreateElement = function()
			{
				var spanElement = document.createElement("span");
				spanElement.className = SlideSorterAreaInstance.PageLinkNonCurrentPageClassName;
				var textNode = document.createTextNode("");
				spanElement.appendChild(textNode);
				this.TextNode = textNode;
				this.Element = spanElement;
				return spanElement;
			}
			
			this.SetTextAndPageNumber = function(text, pageNumber)
			{
				this.TextNode.nodeValue = text;
				this.Text = text;
				this.PageNumber = pageNumber;
			}

			this.MakeLinkUnClickable = function()
			{
				this.Element.className = SlideSorterAreaInstance.PageLinkCurrentPageClassName;
				this.Element.style.textDecoration='none';
				Util.SetCursor(this.Element, CursorType.Default);
				this.Element.onclick = '';
			}

			this.MakeLinkClickable = function()
			{
				this.Element.className = SlideSorterAreaInstance.PageLinkNonCurrentPageClassName;
				this.Element.style.textDecoration='underline';
				Util.SetCursor(this.Element, CursorType.Hand);
				
				this.Element.onclick = new Function("", "SlideSorterAreaInstance.DrawPage(" + this.PageNumber + ");");
			}
			
			this.Hide = function()
			{
				this.Element.style.visibility = 'hidden';
			}
	
			this.Show = function()
			{
				this.Element.style.visibility = 'visible';
			}
		}
	}
}

// ENDFILE SlideSorterArea.js -------------------------------------------------------------------------->

// BEGINFILE TextSlideSorterArea.js -------------------------------------------------------------------->

TextSlideSorterArea.prototype = new AreaBase();
function TextSlideSorterArea(container, containingWindow, ID)
{
	this.m_debugLevel = SfDebug.Verbose;
//	this.m_debugLevel = SfDebug.Information;

	this.LastSelectedSlideNumber = -1;
	this.NumSlideElements = -1;
	
	this.InitializeArea(container, containingWindow, ID);

	this.OnLoad = function()
	{
		this.Debug("TextSlideSorterAreaOnLoad called");
		this.RegisterTextSlideSorterAreaEvents();
		this.SetSlideInitialStatuses();
		this.ScrollingDiv = SfDOM.FindElementFromID(document, this.ID + 'Inside');
	}
	
	this.RegisterTextSlideSorterAreaEvents = function()
	{
		this.SlideChangedEventHandler = new SfEventHandler(this.Container);
		this.SlideChangedEventHandler.Container = this.Container;
		this.SlideChangedEventHandler.MethodName = "OnSlideChangedEvent";
		MainHelper.EventSlideChanged.AddHandler(this.SlideChangedEventHandler);	
		
		this.CommandEventHandler = new SfEventHandler(this.Container);
		this.CommandEventHandler.Container = this.Container;
		this.CommandEventHandler.MethodName = "OnCommandEvent";
		
		MainHelper.EventCommand.AddHandler(this.CommandEventHandler);
	
		this.PlayBeginEventHandler = new SfEventHandler(this.ID);
		this.PlayBeginEventHandler.MethodName = "OnPlayBeginEvent";
		this.PlayBeginEventHandler.Container = this.Container;

		MainHelper.EventPlayBegin.AddHandler(this.PlayBeginEventHandler);
		
	}

	this.OnUnLoad = function()
	{
		MainHelper.EventSlideChanged.RemoveHandler(this.SlideChangedEventHandler);
		MainHelper.EventCommand.RemoveHandler(this.CommandEventHandler);
		MainHelper.EventPlayBegin.RemoveHandler(this.PlayBeginEventHandler);
	}
	
	this.OnPlayBeginEvent = function()
	{
		this.Debug("OnPlayBeginEvent");
		if (this.LastSelectedSlideNumber != -1)
		{
			// unselect the last selected slide
			this.UnHiliteSlide(this.LastSelectedSlideNumber);
			this.LastSelectedSlideNumber = -1;
		}
	}

	this.OnCommandEvent = function(args)
	{
		this.Debug("OnCommandEvent: " + args);
		switch(args.Command)
		{
			case SfCommandType.ShowInfo:
				this.Hide();
				break;
			case SfCommandType.ShowTextSlideList:
				this.SelectSlide(MainHelper.CurrentSlideNumber);
				this.Show();
				break;
		}
	}

	this.OnSlideChangedEvent = function(args)
	{
		this.Debug("OnSlideChangedEvent called");
		var index = args.Index;
		
		if (index < 1)
		{
			// resetting
			if (this.LastSelectedSlideNumber != -1)
			{
				// unselect the last selected slide
				this.UnHiliteSlide(this.LastSelectedSlideNumber);
				this.LastSelectedSlideNumber = -1;
			}
			return;
		}
		
		this.AddDynamicSlidesIfNeeded();
		
		this.SelectSlide(index);
		
	}
	
	this.AddDynamicSlidesIfNeeded = function()
	{
		this.Debug("AddNeededDynamicSlides called");
		
		var max = MainHelper.MaxSlideTimings;
		if (max == this.NumSlideElements)
		{
			return;
		}
		
		var startIndex = this.NumSlideElements + 1;
		var endIndex = max;
		var i;
		for (i=startIndex; i<=endIndex; ++i)
		{
			this.AddDynamicSlide(i);
		}
		this.NumSlideElements = endIndex;
	}
	
	this.SetSlideInitialStatuses = function()
	{
		this.Debug("SetSlideInitialStatuses called");
		this.NumSlideElements = MainHelper.MaxSlideTimings;
		
		if (MainHelper.Presentation.Status == PresentationStatus.CaptureInProgress)
		{
			this.MakeAllSlidesUnClickable();
		}
		
	}
	
	this.MakeAllSlidesClickable = function()
	{
		var max = MainHelper.MaxSlideTimings;
		for (i=0; i<max; ++i)
		{
			this.MakeSlideClickable(i+1);
		}
	}

	this.MakeAllSlidesUnClickable = function()
	{
		var max = MainHelper.MaxSlideTimings;
		for (i=0; i<max; ++i)
		{
			this.MakeSlideUnClickable(i+1);
		}
	}

	this.SelectSlide = function(slideNumber)
	{
		this.Debug("SelectSlide: " + slideNumber + " called");
		if (this.LastSelectedSlideNumber != -1)
		{
			// unselect the last selected slide
			this.UnHiliteSlide(this.LastSelectedSlideNumber);
		}

		this.HiliteSlide(slideNumber);
		this.LastSelectedSlideNumber = slideNumber;
		this.ScrollToSlide(slideNumber);
	}
	
	this.ScrollToSlide = function(slideNumber)
	{
		this.Debug("ScrollToSlide: " + slideNumber);
		if (slideNumber < 0)
		{
			return;
		}

		if (this.ScrollingDiv.clientHeight >= this.ScrollingDiv.scrollHeight)
		{
			this.Debug("No Scrolling necessary");
			return;
		}
		
		var heightPerLine = Math.floor(this.ScrollingDiv.scrollHeight / MainHelper.MaxSlideTimings);
	
		var linesVisible = Math.floor(this.ScrollingDiv.clientHeight / heightPerLine);
		
		var middleLineNumber = Math.ceil(linesVisible / 2);

		this.Debug("HeightPerLine: " + heightPerLine +
			", linesVisible: " + linesVisible + 
			", middleLineNumber: " + middleLineNumber); 
		
		if (slideNumber <= middleLineNumber)
		{
			this.ScrollingDiv.scrollTop = 0;
			return;
		}
		
		this.ScrollingDiv.scrollTop = (slideNumber-middleLineNumber) * heightPerLine;
	}
	
	this.AddDynamicSlide = function(slideNumber)
	{
		this.Debug("AddDynamicSlide " + slideNumber + " called");
		
		var divElem = document.createElement("div");
		divElem.setAttribute("id", "textSlideDiv" + slideNumber);
		divElem.style.cssText = this.TextStyle;
		
		var slideNumberElement = document.createElement("span");
		slideNumberElement.appendChild(document.createTextNode(slideNumber + ". "));
		divElem.appendChild(slideNumberElement);
		
		var titleElement = document.createElement("span");
		titleElement.setAttribute("id", "textSlideTitle");
		titleElement.appendChild(document.createTextNode("Slide " + slideNumber));
		divElem.appendChild(titleElement);
		
		var appendPoint = SfDOM.FindElementFromID(document, this.ID + "Inside");
		if (!appendPoint)
		{
			alert('appendPoint not found parent');
			return;
		}
		appendPoint.appendChild(divElem);
		if (MainHelper.Presentation.Status == PresentationStatus.ReplayReady)
		{
			this.MakeSlideClickable(slideNumber);
		}
	}
	
	this.Debug = function(str)
	{
		SfDebug.DPF(this.m_debugLevel, "TextSlideSorterArea: " + str);
	}

	// remember number is 1 indexed and not 0
	this.NavigateToSlide = function(slideNumber)
	{
		this.Debug("NavigateToSlide(slideNumber: " + slideNumber + ") called");
		var args = new CommandArgs(SfCommandType.NavigateToSlide);
		args.SlideNumber = slideNumber;
		MainHelper.EventCommand.Post(args);
	}

	this.HiliteSlide = function(slideNumber)
	{
		this.Debug("HiliteSlide called");
		var elem = this.FindDivElementForSlideNumber(slideNumber);
		if (elem == null)
		{
			return;
		}
		elem.style.cssText = this.CurrentSlideTextStyle;
	}
	
	this.UnHiliteSlide = function(slideNumber)
	{
		this.Debug("UnHiliteSlide called");
		var elem = this.FindDivElementForSlideNumber(slideNumber);
		if (elem == null)
		{
			return;
		}
		elem.style.cssText = this.TextStyle;
	}
	
	this.MakeSlideClickable = function(slideNumber)
	{
		this.Debug("MakeSlideClickable called");
		var elem = this.FindTitleElementForSlideNumber(slideNumber);
		if (elem == null)
		{
			return;
		}
		elem.style.textDecoration='underline';
		
		Util.SetCursor(elem, CursorType.Hand);
		
		elem.onclick = new Function("", this.Container + ".NavigateToSlide(" + slideNumber + ");");
	}
		
	this.MakeSlideUnClickable = function(slideNumber)
	{
		this.Debug("MakeSlideUnClickable called");
		var elem = this.FindTitleElementForSlideNumber(slideNumber);
		if (elem == null)
		{
			return;
		}
		elem.style.textDecoration='none';
		Util.SetCursor(elem, CursorType.Default);
		elem.onclick = '';
	}

	this.FindDivElementForSlideNumber = function(slideNumber)
	{
		var elem = SfDOM.FindElementFromID(document, "textSlideDiv" + slideNumber);
		if (!elem)
		{
			this.Debug("Could not find element for slideNumber: " + slideNumber);
			return null;
		}
		return elem;
	}	

	this.FindTitleElementForSlideNumber = function(slideNumber)
	{
		var elem = SfDOM.FindElementFromID(document, "textSlideTitle" + slideNumber);
		if (!elem)
		{
			this.Debug("Could not find element for slideNumber: " + slideNumber);
			return null;
		}
		return elem;
	}	
}

// ENDFILE TextSlideSorterArea.js ---------------------------------------------------------------------->